/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.helper.HorseHelper;

public class GuiStatViewer
extends Screen {
    private int xSize = 176;
    private int ySize = 138;
    private static final ResourceLocation TEXTURE = new ResourceLocation("callablehorses", "textures/gui/horse_stat_viewer.png");
    private IHorseOwner owner;
    private AbstractHorseEntity horse;
    private float speed;
    private float jumpHeight;
    private float health;
    private float maxHealth;
    private Vector3d lastPos;
    private RegistryKey<World> lastDim;
    private static Method setColor = ObfuscationReflectionHelper.findMethod(LlamaEntity.class, (String)"func_190711_a", (Class[])new Class[]{DyeColor.class});
    private Minecraft mc = Minecraft.func_71410_x();

    public GuiStatViewer(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent("Horse Stat Viewer"));
        this.owner = HorseHelper.getOwnerCap(player);
        this.horse = this.owner.createHorseEntity(player.field_70170_p);
        this.horse.func_233645_dx_().func_233788_a_(this.owner.getHorseNBT().func_150295_c("Attributes", 10));
        this.horse.func_70020_e(this.owner.getHorseNBT());
        LazyOptional cap = this.horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        cap.ifPresent(horseInventory -> {
            if (horseInventory.getStackInSlot(0).func_190926_b() && this.horse.func_230264_L__()) {
                this.horse.func_230266_a_(null);
            }
            if (this.horse instanceof LlamaEntity && setColor != null) {
                try {
                    ItemStack stack = horseInventory.getStackInSlot(1);
                    if (this.horse.func_190682_f(stack)) {
                        setColor.invoke((Object)this.horse, DyeColor.func_196056_a((int)stack.func_77952_i()));
                    } else {
                        setColor.invoke((Object)this.horse, new Object[]{null});
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        this.health = (float)Math.floor(this.horse.func_110143_aJ());
        this.maxHealth = (float)(Math.floor(this.horse.func_110138_aP() * 10.0f) / 10.0);
        this.speed = (float)(Math.floor(this.horse.func_110148_a(Attributes.field_233821_d_).func_111126_e() * 100.0) / 10.0);
        this.jumpHeight = (float)(Math.floor(this.horse.func_110215_cj() * 100.0) / 10.0);
        this.lastPos = this.owner.getLastSeenPosition();
        this.lastDim = this.owner.getLastSeenDim();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_230708_k_ - this.xSize) / 2;
        int j = (this.field_230709_l_ - this.ySize) / 2;
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)256);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        InventoryScreen.func_228187_a_((int)(i + 43), (int)(j + 68), (int)25, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.horse);
        AbstractGui.func_238475_b_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (ITextComponent)this.horse.func_200200_C_(), (int)(i + 84), (int)(j + 10), (int)DyeColor.WHITE.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)"Health:", (int)(i + 84), (int)(j + 30), (int)DyeColor.LIGHT_GRAY.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)(this.health + "/" + this.maxHealth), (int)(i + 120), (int)(j + 30), (int)DyeColor.WHITE.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)"Speed:", (int)(i + 84), (int)(j + 45), (int)DyeColor.LIGHT_GRAY.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)(this.speed + ""), (int)(i + 120), (int)(j + 45), (int)DyeColor.WHITE.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)"Jump Height:", (int)(i + 84), (int)(j + 60), (int)DyeColor.LIGHT_GRAY.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)(this.jumpHeight + ""), (int)(i + 148), (int)(j + 60), (int)DyeColor.WHITE.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)"Last known position:", (int)(i + 8), (int)(j + 84), (int)DyeColor.LIGHT_GRAY.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)(this.lastPos.equals((Object)Vector3d.field_186680_a) ? "Unknown" : "xyz = " + this.lastPos.func_82615_a() + " " + this.lastPos.func_82617_b() + " " + this.lastPos.func_82616_c()), (int)(i + 8), (int)(j + 94), (int)DyeColor.WHITE.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)"Last known dimension:", (int)(i + 8), (int)(j + 110), (int)DyeColor.LIGHT_GRAY.getColorValue());
        AbstractGui.func_238476_c_((MatrixStack)stack, (FontRenderer)this.mc.field_71466_p, (String)this.lastDim.func_240901_a_().toString(), (int)(i + 8), (int)(j + 120), (int)DyeColor.WHITE.getColorValue());
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.mc.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)keyCode, (int)modifiers))) {
            this.mc.field_71439_g.func_71053_j();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

